@extends('layouts.app')


@section('page-content')
    <div class="content container-fluid">

        <!-- Page Header -->
        <x-breadcrumb class="col">
            <x-slot name="title">{{ __('Invoices') }}</x-slot>
            <ul class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a>
                </li>
                <li class="breadcrumb-item active">
                    {{ __('Preview Invoice') }}
                </li>
            </ul>
            <x-slot name="right">
                <div class="col-auto float-end ms-auto">
                    <div class="btn-group btn-group-sm" x-data="{
                        printContent: function(){
                            const originalContents = $('body').html();
                            var printContents = $('#invoiceSection').html()
                            $('body').empty().html(printContents);
                            window.print();
                            $('body').html(originalContents);
                    }}">
                        <button class="btn btn-white" onclick='window.location.href="{{ route('invoices.index')}}"'>{{ __('Go Back') }}</button>
                        <button class="btn btn-white" @click="function(){
                            let pWidth = 595.28; // the width of a4
                            let srcWidth = document.querySelector('body > div').scrollWidth;
                            let margin = 18; // narrow margin - 1.27 cm (36);
                            let scale = (pWidth - margin * 2) / srcWidth;
                            const doc = new  jsPDF('p', 'pt', 'a4', true);
                            doc.html(document.getElementById('invoiceSection'),{
                                callback: function (doc) {
                                    let totalPages = doc.internal.getNumberOfPages()
                                    {{-- //temporal solution for the blanks pages generated by jspdf --}}
                                    for (var i = 2; i <= totalPages; i++) {
                                        doc.setPage(i);
                                        doc.deletePage(i);
                                        i--;
                                        totalPages--;
                                    }
                                    doc.save('{{ $invoice->inv_id }}.pdf');
                                },
                                html2canvas: {
                                    useCORS: true,
                                    allowTaint: true,
                                    letterRendering: true,
                                    scale: scale,
                                },
                                x: margin,
                                y: margin,
                                autoPaging: 'text',
                                jsPDF: doc,
                            })
                        }">{{ __('PDF') }}</button>
                        <button class="btn btn-white" @click="printContent"><i class="fa-solid fa-print fa-lg"></i> {{ __('Print') }}</button>
                    </div>
                </div>
            </x-slot>
        </x-breadcrumb>
        <!-- /Page Header -->

        <div class="row" id="invoiceSection">
            <div class="col-md-12">
                <x-sales::invoice-card :invoice="$invoice" />
            </div>
        </div>
    </div>
@endsection


@push('page-scripts')
@endpush